#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Fractal sphereMod01.fsh   by guil
//https://www.shadertoy.com/view/4sB3Dc
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
// Based on Weird Thing by inigo quilez : https://www.shadertoy.com/view/XsB3Wc



vec2 iSphere( in vec3 ro, in vec3 rd, in vec4 sph )
{
	vec3 oc = ro - sph.xyz;
	float b = dot( oc, rd );
	float c = dot( oc, oc ) - sph.w*sph.w;
	float h = b*b - c;
	if( h<0.0 ) return vec2(-1.0);
	h = sqrt(h);
	return vec2(-b-h, -b+h );
}

const int MaxIter = 12;
vec3 sundir = vec3(0.0,0.5,-1.0);
float g=.8;
float h=1.;



vec4 map( vec3 p)
{
	float dr = 1.0;
	vec3 ot = vec3(1000.0); 
	float r2;
	for( int i=0; i<MaxIter;i++ )
	{
            
        r2 = dot(p,p);
        if(r2>100.)continue;
		
        ot = min( ot, abs(p) );


		float k = max(h/r2,1.)*g;
		p  *= k;
		dr *= k;
		p=abs(p-0.5)-1.;		
		
	}
	
	float d;
	//d = (abs(p.x)+abs(p.y))*length(p)/dr;	
	//d = (length(p.xz)*abs(p.y)+length(p.xy)*abs(p.z)+length(p.yz)*abs(p.x))/dr;
	//d = 1.5*(length(p.xz))*length(p.xy)/dr;
	//d = 1.*length(p)*log(length(p))/dr;
	//d =1.*length(p)/dr;
    d=abs(p.x)/dr;
	return vec4(ot,d);
	
}

vec4 raymarch( in vec3 ro, in vec3 rd , in vec2 tminmax )
{
	vec4 sum = vec4(0, 0, 0, 0);

	float t = tminmax.x;
	for(int i=0; i<64; i++)
	{
		if( sum.a > 0.99 || t>tminmax.y ) continue;

		vec3 pos = ro + t*rd;		
		vec4 col = map( pos );
		float d = col.a;
		col.a = min(0.002/d,1.);
		col.rgb *= col.a;

		sum = sum + col*(1.0 - sum.a);
        t += min(0.1,d*.3);	
                		
	}

	sum.xyz /= (0.001+sum.w);

	return clamp( sum, 0.0, 1.0 );
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 q = fragCoord.xy / iResolution.xy;
    vec2 p = -1.0 + 2.0*q;
    p.x *= iResolution.x/ iResolution.y;
    vec2 mo = iMouse.xy / iResolution.xy;
    float an = 2.0 + 0.2*iTime - mo.x;

	vec3 ro = 2.0*vec3(cos(an), 0.17, sin(an));
	vec3 ta = vec3(0.0, 0.0, 0.0);
    vec3 ww = normalize( ta - ro);
    vec3 uu = normalize( cross( vec3(0.0,1.0,0.0), ww ) );
    vec3 vv = normalize( cross(ww,uu) );
    vec3 rd = normalize( p.x*uu + p.y*vv + 2.0*ww );

	vec3 col = vec3(0.08,0.09,0.18);
    vec2 seg = iSphere( ro, rd, vec4(0.0,0.0,0.0,1.0) );
	if( seg.x>0.0 )
	{
        vec4 res = raymarch( ro, rd, seg );
	    col = mix( col, res.xyz, res.w );
	}
	
	col = mix( col, vec3(dot(col,vec3(0.333))), -0.1 );
	
	col = pow( col, vec3(0.45) ) * 1.2;

	col *= sqrt( 16.0*q.x*q.y*(1.0-q.x)*(1.0-q.y) );
	    
    fragColor = vec4( col, 1.0 );
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

